/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.entity;

import com.tristankechlo.livingthings.config.entity.ShroomieConfig;
import com.tristankechlo.livingthings.entity.ai.ShroomiePlantMushroomGoal;
import com.tristankechlo.livingthings.entity.misc.IMobVariants;
import com.tristankechlo.livingthings.init.ModEntityTypes;
import com.tristankechlo.livingthings.util.ILexiconEntry;
import com.tristankechlo.livingthings.util.Ingredients;
import com.tristankechlo.livingthings.util.LexiconEntries;
import com.tristankechlo.livingthings.util.LivingThingsTags;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;

public class ShroomieEntity
extends Animal
implements IMobVariants,
ILexiconEntry {
    private static final EntityDataAccessor<Byte> VARIANT = SynchedEntityData.m_135353_(ShroomieEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final UniformInt RANGED_INTEGER = TimeUtil.m_145020_((int)30, (int)60);
    private boolean canPlantMushroom = false;
    private int mushroomCooldown;

    public ShroomieEntity(EntityType<? extends ShroomieEntity> entityType, Level world) {
        super(entityType, world);
    }

    public static boolean checkShroomieSpawnRules(EntityType<ShroomieEntity> animal, LevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return world.m_8055_(pos.m_7495_()).m_204336_(LivingThingsTags.SHROOMIE_SPAWNABLE_ON) && ShroomieEntity.m_186209_((BlockAndTintGetter)world, (BlockPos)pos);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setVariant(tag.m_128445_("ShroomieType"));
        this.mushroomCooldown = tag.m_128451_("MushroomCooldown");
        this.canPlantMushroom = tag.m_128471_("CanPlantMushroom");
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128344_("ShroomieType", this.getVariant());
        tag.m_128405_("MushroomCooldown", this.mushroomCooldown);
        tag.m_128379_("CanPlantMushroom", this.canPlantMushroom);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.25));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.1, Ingredients.SHROOMIE_FOOD, false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(5, (Goal)new ShroomiePlantMushroomGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && this.mushroomCooldown > 0) {
            --this.mushroomCooldown;
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(VARIANT, (Object)0);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, SpawnGroupData data, CompoundTag tag) {
        int brownWeight = (Integer)ShroomieConfig.get().colorBrownWeight.get();
        int redWeight = (Integer)ShroomieConfig.get().colorRedWeight.get();
        this.setVariant(this.getRandomVariant(this.f_19796_, new byte[]{0, 1}, new int[]{brownWeight, redWeight}));
        return super.m_6518_(world, difficulty, reason, data, tag);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(LivingThingsTags.SHROOMIE_FOOD);
    }

    public int m_5792_() {
        return ShroomieConfig.maxSpawnedInChunk();
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return size.f_20378_ * 0.55f;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (this.getVariant() == 1 && stack.m_150930_(Items.f_41953_) || this.getVariant() == 0 && stack.m_150930_(Items.f_41952_)) {
            if (this.m_9236_().f_46443_) {
                return InteractionResult.CONSUME;
            }
            if (!this.canPlantMushroom) {
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
                this.mushroomCooldown += 100;
                this.canPlantMushroom = true;
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        return super.m_6071_(player, hand);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, ShroomieConfig.health()).m_22268_(Attributes.f_22279_, ShroomieConfig.movementSpeed());
    }

    public AgeableMob m_142606_(ServerLevel world, AgeableMob parent) {
        ShroomieEntity shroomie = (ShroomieEntity)ModEntityTypes.SHROOMIE.get().m_20615_((Level)world);
        shroomie.setVariant(this.getVariantFromParents((AgeableMob)this, parent));
        shroomie.m_146762_(0);
        return shroomie;
    }

    public boolean canPlantMushroom() {
        return this.canPlantMushroom && this.mushroomCooldown <= 0;
    }

    public void plantedMushroom() {
        if (this.f_19796_.m_188499_()) {
            this.canPlantMushroom = false;
        }
        this.mushroomCooldown = RANGED_INTEGER.m_214085_(this.f_19796_);
    }

    @Override
    public byte getVariant() {
        return (Byte)this.f_19804_.m_135370_(VARIANT);
    }

    @Override
    public void setVariant(byte type) {
        if (type > 1 || type < 0) {
            return;
        }
        this.f_19804_.m_135381_(VARIANT, (Object)type);
    }

    @Override
    public ResourceLocation getLexiconEntry() {
        return LexiconEntries.SHROOMIE;
    }
}

